"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getAllConfigs;

var _defaultConfigStub = _interopRequireDefault(require("../../stubs/defaultConfig.stub.js"));

var _featureFlags = require("../featureFlags");

var _uniformColorPalette = _interopRequireDefault(require("../flagged/uniformColorPalette.js"));

var _extendedSpacingScale = _interopRequireDefault(require("../flagged/extendedSpacingScale.js"));

var _defaultLineHeights = _interopRequireDefault(require("../flagged/defaultLineHeights.js"));

var _extendedFontSizeScale = _interopRequireDefault(require("../flagged/extendedFontSizeScale.js"));

var _darkModeVariant = _interopRequireDefault(require("../flagged/darkModeVariant.js"));

var _standardFontWeights = _interopRequireDefault(require("../flagged/standardFontWeights"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getAllConfigs(config) {
  const configs = [_defaultConfigStub.default];

  if ((0, _featureFlags.flagEnabled)(config, 'uniformColorPalette')) {
    configs.unshift(_uniformColorPalette.default);
  }

  if ((0, _featureFlags.flagEnabled)(config, 'extendedSpacingScale')) {
    configs.unshift(_extendedSpacingScale.default);
  }

  if ((0, _featureFlags.flagEnabled)(config, 'defaultLineHeights')) {
    configs.unshift(_defaultLineHeights.default);
  }

  if ((0, _featureFlags.flagEnabled)(config, 'extendedFontSizeScale')) {
    configs.unshift(_extendedFontSizeScale.default);
  }

  if ((0, _featureFlags.flagEnabled)(config, 'standardFontWeights')) {
    configs.unshift(_standardFontWeights.default);
  }

  if ((0, _featureFlags.flagEnabled)(config, 'darkModeVariant')) {
    configs.unshift(_darkModeVariant.default);
  }

  return [config, ...configs];
}