'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var React = _interopDefault(require('react'));

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);

  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    if (enumerableOnly) symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    });
    keys.push.apply(keys, symbols);
  }

  return keys;
}

function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};

    if (i % 2) {
      ownKeys(source, true).forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    } else if (Object.getOwnPropertyDescriptors) {
      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
      ownKeys(source).forEach(function (key) {
        Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
      });
    }
  }

  return target;
}

function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}

function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}

function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };

  return _setPrototypeOf(o, p);
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};

  var target = _objectWithoutPropertiesLoose(source, excluded);

  var key, i;

  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }

  return target;
}

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

function _possibleConstructorReturn(self, call) {
  if (call && (typeof call === "object" || typeof call === "function")) {
    return call;
  }

  return _assertThisInitialized(self);
}

var pathRegex = /^(.*\/)([^/]*)$/;
function validImgSrc(placeholder) {
  return placeholder && (pathRegex.test(placeholder) || placeholder.indexOf('data:image') === 0);
}

// 
function parseSrcset(srcset) {
  var sSources = srcset.match(/\s*(?:[\S]*)(?:\s+(?:-?(?:\d+(?:\.(?:\d+)?)?|\.\d+)[a-zA-Z]))?(?:\s*,)?/g);
  if (!Array.isArray(sSources)) throw new Error("\uD83D\uDCA9 srcset is invalid ".concat(JSON.stringify(sSources, null, 2)));
  var sources = [];

  for (var i = 0; i < sSources.length; i += 1) {
    var sSource = sSources[i].trim();

    if (sSource.substr(-1) === ',') {
      sSource = sSource.substr(0, sSource.length - 1).trim();
    }

    var parts = sSource.split(/\s+/, 2);

    if (parts.length === 0 || parts.length === 1 && !parts[0] || parts.length === 2 && !parts[0] && !parts[1]) {
      continue; // eslint-disable-line no-continue
    }

    var url = parts[0];

    if (parts.length === 1 || parts.length === 2 && !parts[1]) {
      // If no "w" or "x" specified, we assume it's "1x".
      sources.push({
        url: url,
        width: undefined,
        dpr: 1
      });
    } else {
      var spec = parts[1].toLowerCase();
      var lastChar = spec.substring(spec.length - 1);

      if (lastChar === 'w') {
        sources.push({
          url: url,
          width: parseFloat(spec),
          dpr: undefined
        });
      } else if (lastChar === 'x') {
        sources.push({
          url: url,
          width: undefined,
          dpr: parseFloat(spec)
        });
      }
    }
  }

  return sources;
}

// 
var findClosestDpr = (function (result, target) {
  return result.reduce(function (prev, curr) {
    return Math.abs(curr.dpr - target) < Math.abs(prev.dpr - target) ? curr : prev;
  });
});

function filterImgSrc(_ref) {
  var _ref$dataset = _ref.dataset,
      src = _ref$dataset.src,
      srcset = _ref$dataset.srcset;
  if (!srcset) return src; // $FlowIgnoreLine: DOM api

  var clientWidth = document.documentElement.clientWidth || window.innerWidth; // eslint-disable-line no-undef

  var devicePixelRatio = window.devicePixelRatio; // eslint-disable-line no-undef

  var parsedSrcset = parseSrcset(srcset);
  var srcInArray = parsedSrcset.map(function (s) {
    return _objectSpread2({}, s, {}, !s.dpr && s.width ? {
      dpr: s.width / clientWidth
    } : null);
  });
  var foundSrc = srcInArray.find(function (_ref2) {
    var dpr = _ref2.dpr;
    return devicePixelRatio === dpr;
  });
  return foundSrc ? foundSrc.url : findClosestDpr(srcInArray, devicePixelRatio).url;
}

// 
var fetchImage = (function (image, imageSrc) {
  return new Promise(function (resolve, error) {
    image.src = imageSrc; // eslint-disable-line no-param-reassign

    image.onload = resolve; // eslint-disable-line no-param-reassign

    image.onerror = error; // eslint-disable-line no-param-reassign
  });
});

// 
function applyStyle(target, withoutPlaceholder) {
  /* eslint-disable */
  target.style.opacity = withoutPlaceholder ? 1 : 0;
  /* eslint-enable */
}
function applyImage(target, image, src) {
  /* eslint-disable */
  target.src = src;
  target.style.visibility = 'visible';

  if (target.dataset.srcset) {
    target.srcset = target.dataset.srcset;
  }

  var withoutPlaceholder = target.getAttribute('data-placeholder') === 'false';
  /* eslint-enable */

  var targetElement = withoutPlaceholder ? target : target.nextSibling;

  if (targetElement) {
    target.addEventListener('load', function () {
      if (!target) return;
      applyStyle(targetElement, withoutPlaceholder);
      target.removeEventListener('load', applyStyle);
    });
  }

  window.__REACT_SIMPLE_IMG__.imgLoadingRefs["delete"](target);
}

// 
function logError(message, target) {
  var e = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';

  if (window.__REACT_SIMPLE_IMG__.logConsoleError) {
    console.error("".concat(message, "\n\n").concat(target.outerHTML, "\n\nand error message ").concat(e.message));
  }
}

function setImageHeight(image, target) {
  image.addEventListener('load', function (e) {
    target.parentNode.style.height = "".concat(e.target.height, "px"); // eslint-disable-line

    target.parentNode.style.visibility = 'visible'; // eslint-disable-line
  });
}

// 
function updateSessionStorage(src) {
  try {
    var cachedImages = JSON.parse(window.sessionStorage.getItem('__REACT_SIMPLE_IMG__')) || {};
    cachedImages[src] = +new Date();
    window.sessionStorage.setItem('__REACT_SIMPLE_IMG__', JSON.stringify(cachedImages));
  } catch (e) {
    logError("Error marking image as cached ".concat(e));
  }
}

// 
function imageLoader(target) {
  try {
    var image = new Image(); // eslint-disable-line no-undef

    var _window$__REACT_SIMPL = window.__REACT_SIMPLE_IMG__,
        observer = _window$__REACT_SIMPL.observer,
        imgLoadingRefs = _window$__REACT_SIMPL.imgLoadingRefs;
    var src = filterImgSrc(target);
    observer.unobserve(target);
    imgLoadingRefs.set(target, image);

    if (!src) {
      logError('Filter Image source returned empty image source', target);
      return;
    }

    if (target.parentNode && target.parentNode.style.height === '1px') {
      setImageHeight(image, target);
    }

    fetchImage(image, src).then(function () {
      if (target) {
        applyImage(target, image, src);
        if (!window.__REACT_SIMPLE_IMG__) return;
        var _window$__REACT_SIMPL2 = window.__REACT_SIMPLE_IMG__,
            disableAnimateCachedImg = _window$__REACT_SIMPL2.disableAnimateCachedImg,
            callBackRefs = _window$__REACT_SIMPL2.callBackRefs;

        if (disableAnimateCachedImg) {
          updateSessionStorage(src);
        }

        var callback = callBackRefs.get(target);
        if (!callback) return;
        callback();
        callBackRefs["delete"](target);
      }
    })["catch"](function (e) {
      logError('Fetch image failed with target', target, e);
    });
  } catch (e) {
    logError('Image loader failed with target', target, e);
  }
}

// 
var defaultConfig = {
  rootMargin: '0px 0px',
  threshold: [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0]
};
function onIntersection(entries) {
  for (var i = 0, len = entries.length; i < len; i++) {
    var _entries$i = entries[i],
        intersectionRatio = _entries$i.intersectionRatio,
        target = _entries$i.target;

    if (intersectionRatio > 0) {
      imageLoader(target);
    }
  }
}
function observerStart() {
  var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultConfig;
  var disableAnimateCachedImg = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var logConsoleError = arguments.length > 2 ? arguments[2] : undefined;
  if (!window.IntersectionObserver) require('intersection-observer'); // $FlowIgnoreLine:

  var observer = new IntersectionObserver(function (entries) {
    return onIntersection(entries);
  }, config);
  window.__REACT_SIMPLE_IMG__ = {
    observer: observer,
    imgLoadingRefs: new Map(),
    callBackRefs: new Map(),
    disableAnimateCachedImg: disableAnimateCachedImg,
    logConsoleError: logConsoleError
  };
  return undefined;
}

// 
function initSimpleImg() {
  var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaultConfig;
  var disableAnimateCachedImg = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var logConsoleError = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  if (typeof window === 'undefined') return;
  observerStart(config, disableAnimateCachedImg, logConsoleError);
}

var commonStyle = {
  position: 'absolute',
  top: 0,
  left: 0,
  width: '100%',
  height: '100%'
};
var defaultImgPlaceholder = 'data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs=';
var defaultPlaceholderColor = 'white';
var hiddenStyle = {
  visibility: 'hidden'
};
var expendWidth = {
  width: '100%'
};
var aspectRatioChildStyle = {
  width: '100%',
  height: '100%',
  position: 'absolute',
  top: 0,
  left: 0
};
var wrapperCommonStyle = {
  position: 'relative',
  overflow: 'hidden',
  display: 'flex',
  flexDirection: 'column',
  justifyContent: 'center',
  alignItems: 'center'
};

// 
function getAspectRatio(_ref) {
  var _ref$height = _ref.height,
      height = _ref$height === void 0 ? 0 : _ref$height,
      _ref$width = _ref.width,
      width = _ref$width === void 0 ? 0 : _ref$width,
      applyAspectRatio = _ref.applyAspectRatio;
  var aspectRatio = parseInt(height, 10) / parseInt(width, 10);
  var shouldUseAspectRatio = applyAspectRatio && !isNaN(aspectRatio); // eslint-disable-line

  var aspectRatioStyle = {
    position: 'relative',
    display: 'block',
    paddingBottom: shouldUseAspectRatio ? "".concat(Math.abs(aspectRatio * 100), "%") : ''
  };
  return {
    shouldUseAspectRatio: shouldUseAspectRatio,
    aspectRatioStyle: aspectRatioStyle
  };
}

var SimpleImg =
/*#__PURE__*/
function (_React$PureComponent) {
  _inherits(SimpleImg, _React$PureComponent);

  function SimpleImg(props) {
    var _this;

    _classCallCheck(this, SimpleImg);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(SimpleImg).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isDocumentLoad: false,
      isCached: false
    });

    _defineProperty(_assertThisInitialized(_this), "element", React.createRef());

    _defineProperty(_assertThisInitialized(_this), "setDocumentLoaded", function () {
      _this.setState({
        isDocumentLoad: true
      });
    });

    if (typeof window !== 'undefined' && !window.__REACT_SIMPLE_IMG__) {
      initSimpleImg();
    }

    return _this;
  }

  _createClass(SimpleImg, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var src = this.props.src;
      var element = this.element.current;

      if (window.__REACT_SIMPLE_IMG__.disableAnimateCachedImg && element // && element.getAttribute('data-from-server') === 'no'
      ) {
          try {
            // Browsers with strict privacy settings could throw an error when
            // attempting to use localStorage and sessionStorage.
            var cachedImagesRefString = window.sessionStorage.getItem('__REACT_SIMPLE_IMG__');
            var cachedImagesRef = JSON.parse(cachedImagesRefString) || {};

            if (cachedImagesRef[src]) {
              this.setState({
                isCached: true
              });
              return;
            }
          } catch (e) {
            logError("Error retrieving cached images ".concat(e));
          }
        }

      if (document.readyState === 'complete') {
        this.triggerImageLoadOrObserver();
      } else {
        window.addEventListener('load', this.setDocumentLoaded);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (!prevState.isDocumentLoad && this.state.isDocumentLoad) {
        this.triggerImageLoadOrObserver();
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      window.removeEventListener('load', this.setDocumentLoaded);
      if (!this.element.current) return;
      var element = this.element.current;
      var _window$__REACT_SIMPL = window.__REACT_SIMPLE_IMG__,
          observer = _window$__REACT_SIMPL.observer,
          imgLoadingRefs = _window$__REACT_SIMPL.imgLoadingRefs,
          callBackRefs = _window$__REACT_SIMPL.callBackRefs;
      observer.unobserve(element);

      if (imgLoadingRefs.has(element)) {
        imgLoadingRefs.get(element).src = '';
        imgLoadingRefs["delete"](element);
      }

      callBackRefs["delete"](element);
    }
  }, {
    key: "triggerImageLoadOrObserver",
    value: function triggerImageLoadOrObserver() {
      var _this$props = this.props,
          importance = _this$props.importance,
          onComplete = _this$props.onComplete;
      var _window$__REACT_SIMPL2 = window.__REACT_SIMPLE_IMG__,
          observer = _window$__REACT_SIMPL2.observer,
          callBackRefs = _window$__REACT_SIMPL2.callBackRefs;

      if (importance === 'auto') {
        imageLoader(this.element.current);
      } else {
        observer.observe(this.element.current);
      }

      if (onComplete) callBackRefs.set(this.element.current, onComplete);
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          src = _this$props2.src,
          className = _this$props2.className,
          height = _this$props2.height,
          width = _this$props2.width,
          alt = _this$props2.alt,
          srcSet = _this$props2.srcSet,
          applyAspectRatio = _this$props2.applyAspectRatio,
          _this$props2$animatio = _this$props2.animationDuration,
          animationDuration = _this$props2$animatio === void 0 ? 0.3 : _this$props2$animatio,
          _this$props2$placehol = _this$props2.placeholder,
          placeholder = _this$props2$placehol === void 0 ? defaultPlaceholderColor : _this$props2$placehol,
          _this$props2$style = _this$props2.style,
          style = _this$props2$style === void 0 ? {} : _this$props2$style,
          restProps = _objectWithoutProperties(_this$props2, ["src", "className", "height", "width", "alt", "srcSet", "applyAspectRatio", "animationDuration", "placeholder", "style"]);

      var isCached = this.state.isCached;
      var disablePlaceholder = placeholder === false;
      var isValidImgSrc = validImgSrc(placeholder);

      var inlineStyle = _objectSpread2({}, commonStyle, {}, !isValidImgSrc ? {
        background: placeholder
      } : null, {
        transition: "".concat(animationDuration, "s opacity")
      });

      var imgPlaceholder = isValidImgSrc ? placeholder : defaultImgPlaceholder;
      var isSrcSetFulfilled = this.element.current && this.element.current.src !== imgPlaceholder;

      var importance = restProps.importance,
          onComplete = restProps.onComplete,
          imgStyle = restProps.imgStyle,
          restImgProps = _objectWithoutProperties(restProps, ["importance", "onComplete", "imgStyle"]);

      var heightWidth = _objectSpread2({}, height ? {
        height: style.height || height
      } : null, {}, width ? {
        width: style.width || width
      } : null);

      var isHeightAndWidthNotSet = !height && !width;

      var _getAspectRatio = getAspectRatio({
        height: height,
        width: width,
        applyAspectRatio: applyAspectRatio
      }),
          shouldUseAspectRatio = _getAspectRatio.shouldUseAspectRatio,
          aspectRatioStyle = _getAspectRatio.aspectRatioStyle;

      var imageProps = _objectSpread2({
        alt: alt,
        src: isCached ? src : imgPlaceholder,
        srcSet: isCached ? srcSet : null
      }, isCached ? null : _objectSpread2({
        ref: this.element
      }, disablePlaceholder ? {
        'data-placeholder': 'false'
      } : null, {
        'data-src': src,
        'data-srcset': srcSet
      }), {}, restImgProps);

      var noScript = React.createElement("noscript", null, React.createElement("img", {
        src: src,
        alt: alt,
        style: imgStyle,
        className: className
      }));

      if (disablePlaceholder && !applyAspectRatio) {
        return React.createElement(React.Fragment, null, noScript, React.createElement("img", _extends({
          style: _objectSpread2({}, style, {}, isCached ? null : {
            transition: "".concat(animationDuration, "s opacity"),
            opacity: 0
          }, {}, imgStyle),
          className: className
        }, heightWidth, imageProps)));
      }

      var placeholderComponent = isValidImgSrc ? React.createElement("img", _extends({
        style: inlineStyle,
        src: placeholder,
        alt: alt
      }, restImgProps)) : React.createElement("div", {
        style: inlineStyle
      });

      if (isCached) {
        return React.createElement("div", {
          style: _objectSpread2({}, shouldUseAspectRatio ? aspectRatioStyle : _objectSpread2({}, heightWidth, {}, wrapperCommonStyle, {}, style)),
          className: className
        }, React.createElement("img", _extends({
          style: _objectSpread2({}, isHeightAndWidthNotSet ? expendWidth : heightWidth, {}, shouldUseAspectRatio ? aspectRatioChildStyle : null, {}, imgStyle)
        }, imageProps)), noScript);
      }

      return React.createElement("div", {
        style: _objectSpread2({}, shouldUseAspectRatio ? aspectRatioStyle : _objectSpread2({}, wrapperCommonStyle, {}, height ? {
          height: height
        } : {
          height: 1,
          visibility: 'hidden'
        }, {}, style)),
        className: className
      }, noScript, React.createElement("img", _extends({
        style: _objectSpread2({}, isHeightAndWidthNotSet ? expendWidth : heightWidth, {}, !isValidImgSrc && !isSrcSetFulfilled ? hiddenStyle : {}, {}, shouldUseAspectRatio ? aspectRatioChildStyle : null, {}, disablePlaceholder ? {
          transition: "".concat(animationDuration, "s opacity"),
          opacity: 0
        } : null, {}, imgStyle)
      }, imageProps)), !disablePlaceholder && placeholderComponent);
    }
  }]);

  return SimpleImg;
}(React.PureComponent);

_defineProperty(SimpleImg, "defaultProps", {
  animationDuration: 0.3,
  importance: 'low',
  placeholder: defaultPlaceholderColor
});

exports.SimpleImg = SimpleImg;
exports.initSimpleImg = initSimpleImg;
