"use strict";exports.__esModule=true;exports.hasNecessaryDependencies=hasNecessaryDependencies;var _chalk=_interopRequireDefault(require("next/dist/compiled/chalk"));var _path=_interopRequireDefault(require("path"));var _fileExists=require("../file-exists");var _oxfordCommaList=require("../oxford-comma-list");var _resolveRequest=require("../resolve-request");var _FatalTypeScriptError=require("./FatalTypeScriptError");function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}const requiredPackages=[{file:'typescript',pkg:'typescript'},{file:'@types/react/index.d.ts',pkg:'@types/react'},{file:'@types/node/index.d.ts',pkg:'@types/node'}];async function hasNecessaryDependencies(baseDir){let resolutions=new Map();const missingPackages=requiredPackages.filter(p=>{try{resolutions.set(p.pkg,(0,_resolveRequest.resolveRequest)(p.file,_path.default.join(baseDir,'/')));return false;}catch(_){return true;}});if(missingPackages.length<1){return{resolvedTypeScript:resolutions.get('typescript')};}const packagesHuman=(0,_oxfordCommaList.getOxfordCommaList)(missingPackages.map(p=>p.pkg));const packagesCli=missingPackages.map(p=>p.pkg).join(' ');const yarnLockFile=_path.default.join(baseDir,'yarn.lock');const isYarn=await(0,_fileExists.fileExists)(yarnLockFile).catch(()=>false);throw new _FatalTypeScriptError.FatalTypeScriptError(_chalk.default.bold.red(`It looks like you're trying to use TypeScript but do not have the required package(s) installed.`)+'\n\n'+_chalk.default.bold(`Please install ${_chalk.default.bold(packagesHuman)} by running:`)+'\n\n'+`\t${_chalk.default.bold.cyan((isYarn?'yarn add --dev':'npm install --save-dev')+' '+packagesCli)}`+'\n\n'+_chalk.default.bold('If you are not trying to use TypeScript, please remove the '+_chalk.default.cyan('tsconfig.json')+' file from your package root (and any TypeScript files in your pages directory).')+'\n');}
//# sourceMappingURL=hasNecessaryDependencies.js.map