"use strict";exports.__esModule=true;exports.default=void 0;var _webpack=_interopRequireDefault(require("webpack"));var _webpackSources=_interopRequireDefault(require("webpack-sources"));var _path=require("path");var _getRouteFromEntrypoint=_interopRequireDefault(require("../../../next-server/server/get-route-from-entrypoint"));function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}const SSR_MODULE_CACHE_FILENAME='ssr-module-cache.js';// @ts-ignore: TODO: remove ignore when webpack 5 is stable
const{RawSource}=_webpack.default.sources||_webpackSources.default;// By default webpack keeps initialized modules per-module.
// This means that if you have 2 entrypoints loaded into the same app
// they will *not* share the same instance
// This creates many issues when developers / libraries rely on the singleton pattern
// As this pattern assumes every module will have 1 instance
// This plugin overrides webpack's code generation step to replace `installedModules`
// The replacement is a require for a file that's also generated here that only exports an empty object
// Because of Node.js's single instance modules this makes webpack share all initialized instances
// Do note that this module is only geared towards the `node` compilation target.
// For the client side compilation we use `runtimeChunk: 'single'`
class NextJsSsrImportPlugin{constructor(options){this.options=void 0;this.options=options;}apply(compiler){const{outputPath}=this.options;compiler.hooks.emit.tapAsync('NextJsSSRModuleCache',(compilation,callback)=>{compilation.assets[SSR_MODULE_CACHE_FILENAME]=new RawSource(`
      /* This cache is used by webpack for instantiated modules */
      module.exports = {}
      `);callback();});compiler.hooks.compilation.tap('NextJsSSRModuleCache',compilation=>{compilation.mainTemplate.hooks.localVars.intercept({register(tapInfo){if(tapInfo.name==='MainTemplate'){const originalFn=tapInfo.fn;tapInfo.fn=(source,chunk)=>{// If the chunk is not part of the pages directory we have to keep the original behavior,
// otherwise webpack will error out when the file is used before the compilation finishes
// this is the case with mini-css-extract-plugin
if(!(0,_getRouteFromEntrypoint.default)(chunk.name)){return originalFn(source,chunk);}const pagePath=(0,_path.join)(outputPath,(0,_path.dirname)(chunk.name));let relativePathToBaseDir=(0,_path.relative)(pagePath,(0,_path.join)(outputPath,SSR_MODULE_CACHE_FILENAME));// Make sure even in windows, the path looks like in unix
// Node.js require system will convert it accordingly
const relativePathToBaseDirNormalized=relativePathToBaseDir.replace(/\\/g,'/');return _webpack.default.Template.asString([source,'// The module cache',`var installedModules = require('${relativePathToBaseDirNormalized}');`]);};}return tapInfo;}});});}}exports.default=NextJsSsrImportPlugin;
//# sourceMappingURL=nextjs-ssr-module-cache.js.map