"use strict";exports.__esModule=true;exports.FontStylesheetGatheringPlugin=void 0;var _webpack=_interopRequireDefault(require("webpack"));var _webpackSources=_interopRequireDefault(require("webpack-sources"));var _fontUtils=require("../../../next-server/server/font-utils");var _BasicEvaluatedExpression=_interopRequireDefault(require("webpack/lib/BasicEvaluatedExpression"));var _postcss=_interopRequireDefault(require("postcss"));var _cssnanoSimple=_interopRequireDefault(require("cssnano-simple"));var _constants=require("../../../next-server/lib/constants");function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}// @ts-ignore
// @ts-ignore: TODO: remove ignore when webpack 5 is stable
const{RawSource}=_webpack.default.sources||_webpackSources.default;const isWebpack5=parseInt(_webpack.default.version)===5;async function minifyCss(css){return new Promise(resolve=>(0,_postcss.default)([(0,_cssnanoSimple.default)({excludeAll:true,discardComments:true,normalizeWhitespace:{exclude:false}})]).process(css,{from:undefined}).then(res=>{resolve(res.css);}));}class FontStylesheetGatheringPlugin{constructor(){this.compiler=void 0;this.gatheredStylesheets=[];this.manifestContent=[];this.parserHandler=factory=>{const JS_TYPES=['auto','esm','dynamic'];// Do an extra walk per module and add interested visitors to the walk.
for(const type of JS_TYPES){factory.hooks.parser.for('javascript/'+type).tap(this.constructor.name,parser=>{/**
           * Webpack fun facts:
           * `parser.hooks.call.for` cannot catch calls for user defined identifiers like `__jsx`
           * it can only detect calls for native objects like `window`, `this`, `eval` etc.
           * In order to be able to catch calls of variables like `__jsx`, first we need to catch them as
           * Identifier and then return `BasicEvaluatedExpression` whose `id` and `type` webpack matches to
           * invoke hook for call.
           * See: https://github.com/webpack/webpack/blob/webpack-4/lib/Parser.js#L1931-L1932.
           */parser.hooks.evaluate.for('Identifier').tap(this.constructor.name,node=>{var _parser$state,_parser$state$module;// We will only optimize fonts from first party code.
if(parser==null?void 0:(_parser$state=parser.state)==null?void 0:(_parser$state$module=_parser$state.module)==null?void 0:_parser$state$module.resource.includes('node_modules')){return;}return node.name==='__jsx'?new _BasicEvaluatedExpression.default()//@ts-ignore
.setRange(node.range).setExpression(node).setIdentifier('__jsx'):undefined;});parser.hooks.call.for('__jsx').tap(this.constructor.name,node=>{if(node.arguments.length!==2){// A font link tag has only two arguments rel=stylesheet and href='...'
return;}if(!isNodeCreatingLinkElement(node)){return;}// node.arguments[0] is the name of the tag and [1] are the props.
const propsNode=node.arguments[1];const props={};propsNode.properties.forEach(prop=>{if(prop.type!=='Property'){return;}if(prop.key.type==='Identifier'&&prop.value.type==='Literal'){props[prop.key.name]=prop.value.value;}});if(!props.rel||props.rel!=='stylesheet'||!props.href||!_constants.OPTIMIZED_FONT_PROVIDERS.some(url=>props.href.startsWith(url))){return false;}this.gatheredStylesheets.push(props.href);});});}};}apply(compiler){this.compiler=compiler;compiler.hooks.normalModuleFactory.tap(this.constructor.name,this.parserHandler);compiler.hooks.make.tapAsync(this.constructor.name,(compilation,cb)=>{// @ts-ignore
if(compilation.options.output.path.endsWith('serverless')){/**
         * Inline font manifest for serverless case only.
         * For target: server drive the manifest through physical file and less of webpack magic.
         */const mainTemplate=compilation.mainTemplate;mainTemplate.hooks.requireExtensions.tap(this.constructor.name,source=>{return`${source}
                // Font manifest declaration
                ${mainTemplate.requireFn}.__NEXT_FONT_MANIFEST__ = ${JSON.stringify(this.manifestContent)};`;});}compilation.hooks.finishModules.tapAsync(this.constructor.name,async(_,modulesFinished)=>{const fontDefinitionPromises=this.gatheredStylesheets.map(url=>(0,_fontUtils.getFontDefinitionFromNetwork)(url));this.manifestContent=[];for(let promiseIndex in fontDefinitionPromises){const css=await fontDefinitionPromises[promiseIndex];const content=await minifyCss(css);this.manifestContent.push({url:this.gatheredStylesheets[promiseIndex],content});}if(!isWebpack5){compilation.assets['font-manifest.json']=new RawSource(JSON.stringify(this.manifestContent,null,'  '));}modulesFinished();});cb();});if(isWebpack5){compiler.hooks.make.tap(this.constructor.name,compilation=>{// @ts-ignore TODO: Remove ignore when webpack 5 is stable
compilation.hooks.processAssets.tap({name:this.constructor.name,// @ts-ignore TODO: Remove ignore when webpack 5 is stable
stage:_webpack.default.Compilation.PROCESS_ASSETS_STAGE_ADDITIONS},assets=>{assets['font-manifest.json']=new RawSource(JSON.stringify(this.manifestContent,null,'  '));});});}}}exports.FontStylesheetGatheringPlugin=FontStylesheetGatheringPlugin;function isNodeCreatingLinkElement(node){const callee=node.callee;if(callee.type!=='Identifier'){return false;}const componentNode=node.arguments[0];if(componentNode.type!=='Literal'){return false;}// Next has pragma: __jsx.
return callee.name==='__jsx'&&componentNode.value==='link';}
//# sourceMappingURL=font-stylesheet-gathering-plugin.js.map