"use strict";exports.__esModule=true;exports.CssMinimizerPlugin=void 0;var _cssnanoSimple=require("cssnano-simple");var _webpack=_interopRequireDefault(require("webpack"));var _webpackSources=_interopRequireDefault(require("webpack-sources"));function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}// @ts-ignore: TODO: remove ignore when webpack 5 is stable
const{RawSource,SourceMapSource}=_webpack.default.sources||_webpackSources.default;// https://github.com/NMFR/optimize-css-assets-webpack-plugin/blob/0a410a9bf28c7b0e81a3470a13748e68ca2f50aa/src/index.js#L20
const CSS_REGEX=/\.css(\?.*)?$/i;const isWebpack5=parseInt(_webpack.default.version)===5;class CssMinimizerPlugin{constructor(options){this.__next_css_remove=true;this.options=void 0;this.options=options;}optimizeAsset(file,asset){const postcssOptions={...this.options.postcssOptions,to:file,from:file};let input;if(postcssOptions.map&&asset.sourceAndMap){const{source,map}=asset.sourceAndMap();input=source;postcssOptions.map.prev=map?map:false;}else{input=asset.source();}return(0,_cssnanoSimple.process)(input,postcssOptions).then(res=>{if(res.map){return new SourceMapSource(res.css,file,res.map.toJSON());}else{return new RawSource(res.css);}});}apply(compiler){compiler.hooks.compilation.tap('CssMinimizerPlugin',compilation=>{if(isWebpack5){const cache=compilation.getCache('CssMinimizerPlugin');compilation.hooks.processAssets.tapPromise({name:'CssMinimizerPlugin',// @ts-ignore TODO: Remove ignore when webpack 5 is stable
stage:_webpack.default.Compilation.PROCESS_ASSETS_STAGE_OPTIMIZE_SIZE},async assets=>{const files=Object.keys(assets);await Promise.all(files.filter(file=>CSS_REGEX.test(file)).map(async file=>{const asset=assets[file];const etag=cache.getLazyHashedEtag(asset);const cachedResult=await cache.getPromise(file,etag);if(cachedResult){assets[file]=cachedResult;return;}const result=await this.optimizeAsset(file,asset);await cache.storePromise(file,etag,result);assets[file]=result;}));});return;}compilation.hooks.optimizeChunkAssets.tapPromise('CssMinimizerPlugin',chunks=>Promise.all(chunks.reduce((acc,chunk)=>acc.concat(chunk.files||[]),[]).filter(entry=>CSS_REGEX.test(entry)).map(async file=>{const asset=compilation.assets[file];compilation.assets[file]=await this.optimizeAsset(file,asset);})));});}}exports.CssMinimizerPlugin=CssMinimizerPlugin;
//# sourceMappingURL=css-minimizer-plugin.js.map