"use strict";exports.__esModule=true;exports.default=void 0;var _devalue=_interopRequireDefault(require("next/dist/compiled/devalue"));var _webpack=_interopRequireDefault(require("webpack"));var _webpackSources=_interopRequireDefault(require("webpack-sources"));var _constants=require("../../../next-server/lib/constants");var _getRouteFromEntrypoint=_interopRequireDefault(require("../../../next-server/server/get-route-from-entrypoint"));var _nextDropClientPagePlugin=require("./next-drop-client-page-plugin");var _utils=require("../../../next-server/lib/router/utils");function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj};}// @ts-ignore: TODO: remove ignore when webpack 5 is stable
const{RawSource}=_webpack.default.sources||_webpackSources.default;const isWebpack5=parseInt(_webpack.default.version)===5;// This function takes the asset map generated in BuildManifestPlugin and creates a
// reduced version to send to the client.
function generateClientManifest(assetMap,isModern,rewrites){const clientManifest={// TODO: update manifest type to include rewrites
__rewrites:rewrites};const appDependencies=new Set(assetMap.pages['/_app']);const sortedPageKeys=(0,_utils.getSortedRoutes)(Object.keys(assetMap.pages));sortedPageKeys.forEach(page=>{const dependencies=assetMap.pages[page];if(page==='/_app')return;// Filter out dependencies in the _app entry, because those will have already
// been loaded by the client prior to a navigation event
const filteredDeps=dependencies.filter(dep=>!appDependencies.has(dep)&&(!dep.endsWith('.js')||dep.endsWith('.module.js')===isModern));// The manifest can omit the page if it has no requirements
if(filteredDeps.length){clientManifest[page]=filteredDeps;}});// provide the sorted pages as an array so we don't rely on the object's keys
// being in order and we don't slow down look-up time for page assets
clientManifest.sortedPages=sortedPageKeys;return(0,_devalue.default)(clientManifest);}function isJsFile(file){// We don't want to include `.hot-update.js` files into the initial page
return!file.endsWith('.hot-update.js')&&file.endsWith('.js');}function getFilesArray(files){if(!files){return[];}if(isWebpack5){return Array.from(files);}return files;}// This plugin creates a build-manifest.json for all assets that are being output
// It has a mapping of "entry" filename to real filename. Because the real filename can be hashed in production
class BuildManifestPlugin{constructor(options){this.buildId=void 0;this.modern=void 0;this.rewrites=void 0;this.buildId=options.buildId;this.modern=options.modern;this.rewrites=options.rewrites.map(r=>{const rewrite={...r};// omit external rewrite destinations since these aren't
// handled client-side
if(!rewrite.destination.startsWith('/')){delete rewrite.destination;}return rewrite;});}createAssets(compilation,assets){const namedChunks=compilation.namedChunks;const assetMap={polyfillFiles:[],devFiles:[],ampDevFiles:[],lowPriorityFiles:[],pages:{'/_app':[]},ampFirstPages:[]};const ampFirstEntryNames=_nextDropClientPagePlugin.ampFirstEntryNamesMap.get(compilation);if(ampFirstEntryNames){for(const entryName of ampFirstEntryNames){const pagePath=(0,_getRouteFromEntrypoint.default)(entryName);if(!pagePath){continue;}assetMap.ampFirstPages.push(pagePath);}}const mainJsChunk=namedChunks.get(_constants.CLIENT_STATIC_FILES_RUNTIME_MAIN);const mainJsFiles=getFilesArray(mainJsChunk==null?void 0:mainJsChunk.files).filter(isJsFile);const polyfillChunk=namedChunks.get(_constants.CLIENT_STATIC_FILES_RUNTIME_POLYFILLS);// Create a separate entry  for polyfills
assetMap.polyfillFiles=getFilesArray(polyfillChunk==null?void 0:polyfillChunk.files).filter(isJsFile);const reactRefreshChunk=namedChunks.get(_constants.CLIENT_STATIC_FILES_RUNTIME_REACT_REFRESH);assetMap.devFiles=getFilesArray(reactRefreshChunk==null?void 0:reactRefreshChunk.files).filter(isJsFile);for(const entrypoint of compilation.entrypoints.values()){const isAmpRuntime=entrypoint.name===_constants.CLIENT_STATIC_FILES_RUNTIME_AMP;if(isAmpRuntime){for(const file of entrypoint.getFiles()){if(!(isJsFile(file)||file.endsWith('.css'))){continue;}assetMap.ampDevFiles.push(file.replace(/\\/g,'/'));}continue;}const pagePath=(0,_getRouteFromEntrypoint.default)(entrypoint.name);if(!pagePath){continue;}const filesForEntry=[];// getFiles() - helper function to read the files for an entrypoint from stats object
for(const file of entrypoint.getFiles()){if(!(isJsFile(file)||file.endsWith('.css'))){continue;}filesForEntry.push(file.replace(/\\/g,'/'));}assetMap.pages[pagePath]=[...mainJsFiles,...filesForEntry];}// Add the runtime build manifest file (generated later in this file)
// as a dependency for the app. If the flag is false, the file won't be
// downloaded by the client.
assetMap.lowPriorityFiles.push(`${_constants.CLIENT_STATIC_FILES_PATH}/${this.buildId}/_buildManifest.js`);if(this.modern){assetMap.lowPriorityFiles.push(`${_constants.CLIENT_STATIC_FILES_PATH}/${this.buildId}/_buildManifest.module.js`);}// Add the runtime ssg manifest file as a lazy-loaded file dependency.
// We also stub this file out for development mode (when it is not
// generated).
const srcEmptySsgManifest=`self.__SSG_MANIFEST=new Set;self.__SSG_MANIFEST_CB&&self.__SSG_MANIFEST_CB()`;const ssgManifestPath=`${_constants.CLIENT_STATIC_FILES_PATH}/${this.buildId}/_ssgManifest.js`;assetMap.lowPriorityFiles.push(ssgManifestPath);assets[ssgManifestPath]=new RawSource(srcEmptySsgManifest);if(this.modern){const ssgManifestPathModern=`${_constants.CLIENT_STATIC_FILES_PATH}/${this.buildId}/_ssgManifest.module.js`;assetMap.lowPriorityFiles.push(ssgManifestPathModern);assets[ssgManifestPathModern]=new RawSource(srcEmptySsgManifest);}assetMap.pages=Object.keys(assetMap.pages).sort()// eslint-disable-next-line
.reduce((a,c)=>(a[c]=assetMap.pages[c],a),{});assets[_constants.BUILD_MANIFEST]=new RawSource(JSON.stringify(assetMap,null,2));const clientManifestPath=`${_constants.CLIENT_STATIC_FILES_PATH}/${this.buildId}/_buildManifest.js`;assets[clientManifestPath]=new RawSource(`self.__BUILD_MANIFEST = ${generateClientManifest(assetMap,false,this.rewrites)};self.__BUILD_MANIFEST_CB && self.__BUILD_MANIFEST_CB()`);if(this.modern){const modernClientManifestPath=`${_constants.CLIENT_STATIC_FILES_PATH}/${this.buildId}/_buildManifest.module.js`;assets[modernClientManifestPath]=new RawSource(`self.__BUILD_MANIFEST = ${generateClientManifest(assetMap,true,this.rewrites)};self.__BUILD_MANIFEST_CB && self.__BUILD_MANIFEST_CB()`);}return assets;}apply(compiler){if(isWebpack5){compiler.hooks.make.tap('NextJsBuildManifest',compilation=>{// @ts-ignore TODO: Remove ignore when webpack 5 is stable
compilation.hooks.processAssets.tap({name:'NextJsBuildManifest',// @ts-ignore TODO: Remove ignore when webpack 5 is stable
stage:_webpack.default.Compilation.PROCESS_ASSETS_STAGE_ADDITIONS},assets=>{this.createAssets(compilation,assets);});});return;}compiler.hooks.emit.tap('NextJsBuildManifest',compilation=>{this.createAssets(compilation,compilation.assets);});}}exports.default=BuildManifestPlugin;
//# sourceMappingURL=build-manifest-plugin.js.map