
/*
  Identify the first focusable element in the element's ancestry, including itself
*/

import getFocusRedirectTarget from './focus-redirect-target';
import getParents from '../get/parents';
import isFocusable from '../is/focusable';
import contextToElement from '../util/context-to-element';

export default function () {
  var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
      context = _ref.context,
      except = _ref.except;

  var element = contextToElement({
    label: 'get/focus-target',
    context: context
  });

  var result = null;
  var getTarget = function getTarget(_element) {
    var focusable = isFocusable.rules({
      context: _element,
      except: except
    });

    if (focusable) {
      result = _element;
      return true;
    }

    result = getFocusRedirectTarget({
      context: _element,
      skipFocusable: true
    });

    return Boolean(result);
  };

  if (getTarget(element)) {
    return result;
  }

  getParents({ context: element }).slice(1).some(getTarget);
  return result;
}
//# sourceMappingURL=focus-target.js.map